<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Server-Sent Events Example</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <h1>Server-Sent Events Example</h1>
    <div id="messages"></div>

    <script>
        // Set up the EventSource to listen to the server.php script
        const eventSource = new EventSource('checkLockAPI.php');

        // Handle incoming messages
        eventSource.onmessage = function (event) {
            const data = JSON.parse(event.data);
            $('#messages').append('<p>' + data.message + ' (' + new Date(data.timestamp * 1000).toLocaleTimeString() + ')</p>');
        };

        // Handle errors
        eventSource.onerror = function (event) {
            console.error('Error with SSE:', event);
        };
    </script>
</body>
</html>